package com.qboxus.tictic.simpleclasses

import android.app.Activity

object ActivityManager {
    private val activities = mutableListOf<Activity>()

    fun registerActivity(activity: Activity) {
        activities.add(activity)
    }

    fun unregisterActivity(activity: Activity) {
        activities.remove(activity)
    }

    fun finishAll() {
        for (activity in activities) {
            activity.finish()
        }
        activities.clear()
    }
}
